/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.anklesprainermod.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelMario
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"ankle_sprainer_mod", (String)"model_mario"), "main");
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;
    public final ModelPart Body;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart Head;
    public final ModelPart Hat;
    public final ModelPart Mustache;

    public ModelMario(ModelPart root) {
        super(root);
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.Body = root.getChild("Body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.Head = root.getChild("Head");
        this.Hat = this.Head.getChild("Hat");
        this.Mustache = this.Head.getChild("Mustache");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(32, 22).addBox(-1.0f, 5.0f, -4.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(36, 0).addBox(-1.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)17.0f, (float)1.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 29).addBox(-2.0f, 5.0f, -4.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(14, 33).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)17.0f, (float)1.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(28, 11).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-2.0f, -1.0f, -3.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(36, 36).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)10.0f, (float)1.0f));
        PartDefinition RightHand_r1 = RightArm.addOrReplaceChild("RightHand_r1", CubeListBuilder.create().texOffs(22, 44).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(26, 36).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)10.0f, (float)1.0f));
        PartDefinition LeftHand_r1 = LeftArm.addOrReplaceChild("LeftHand_r1", CubeListBuilder.create().texOffs(12, 41).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(-5.0f, -6.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 44).addBox(4.0f, -6.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 44).addBox(-1.0f, -4.0f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition Hat = Head.addOrReplaceChild("Hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition HatExtra_r1 = Hat.addOrReplaceChild("HatExtra_r1", CubeListBuilder.create().texOffs(0, 25).addBox(-5.0f, -2.0f, -1.0f, 10.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-23.0f, (float)-4.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition HatMain_r1 = Hat.addOrReplaceChild("HatMain_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.0f, -4.0f, 10.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-23.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition Mustache = Head.addOrReplaceChild("Mustache", CubeListBuilder.create().texOffs(26, 33).addBox(-1.0f, -17.0f, -4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition MustacheLeft_r1 = Mustache.addOrReplaceChild("MustacheLeft_r1", CubeListBuilder.create().texOffs(36, 8).addBox(0.0f, -2.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-15.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition MustacheRight_r1 = Mustache.addOrReplaceChild("MustacheRight_r1", CubeListBuilder.create().texOffs(42, 8).addBox(0.0f, -2.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-16.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

